﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<script runat="server">

    void Grid_BeforeRow(Object sender, RowEventArgs args) {
        DokumentHandlowy dokument = (DokumentHandlowy)args.Row;
        foreach (Platnosc p in dokument.Platnosci) {
            termin.AddLine(p.Termin);
            kwota.AddLine(p.Kwota);
            pozostaje.AddLine(p.DoRozliczenia);
        }
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Rozliczenie dokumentów zakupu</title> 
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server"></ea:DataContext>
        <eb:ReportHeader id="ReportHeader" title="Rozliczenie dokumentów zakupu|</STRONG>Definicja:<STRONG> {1}|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}|</STRONG>Kontrahent:<STRONG> {4}" runat="server" DataMember4="DokHandloweViewInfo+WParams.Kontrahent" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres" DataMember1="DokHandloweViewInfo+WParams.Definicja"></eb:ReportHeader>
        <ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" OnBeforeRow="Grid_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="18" Align="Left" DataMember="Numer" Caption="Dokument~Numer" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Center" DataMember="Data" Caption="Dokument~Data" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Align="Left" DataMember="Kontrahent" Caption="Dokument~Kontrahent" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Center" Caption="Płatności~Termin" ID="termin" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Płatności~Kwota" ID="kwota" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Płatności~Pozostaje" ID="pozostaje" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Suma.Netto" Total="Sum" Caption="Wartość dokumentu~Netto" Format="{0:n}" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Suma.VAT" Total="Sum" Caption="Wartość dokumentu~VAT" Format="{0:n}" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Suma.Brutto" Total="Sum" Caption="Wartość dokumentu~Brutto" Format="{0:n}" VAlign="Top" runat="server" EncodeHTML="True"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
    </form>
</body>
</html>

